/*==========================
 Add Your Bookmarks - NOTE: live image src links must be used when opening multiple bookmarks at once due to browser Same-Origin Policy.

 IIR:
 https://d2q79iu7y748jz.cloudfront.net/s/_squarelogo/256x256/2e89880acf601ebd0fcd000b36253023
 https://iir.applicantpro.com/images/4/5189/IRR_fblogoNEW.jpg
 https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSagFBfh3urNMUeq1kkF1w1K1xuwsH7naSk_A&s
==========================*/
const addBookmarks = [
	{	src: "img/bookmarks/okta.jpg",
		link: "https://okta.com/",
		alt: "Okta Apps"
	},
	{	src: "img/bookmarks/workday.jpg",
		link: "https://workday.com/",
		alt: "Workday"
	},
	{	src: "img/bookmarks/d365.jpg",
		link: "https://www.microsoft.com/en-us/dynamics-365",
		alt: "D365"
	},
	{	src: "img/bookmarks/motivosity.jpg",
		link: "https://www.motivosity.com/",
		alt: "Motivosity"
	},
	{	src: "img/bookmarks/litmus.jpg",
		link: "https://litmus.com/",
		alt: "Litmus"
	},
	{	src: "img/bookmarks/eoa.jpg",
		link: "https://emailonacid.com/",
		alt: "Email On Acid"
	},
	{	src: "img/bookmarks/figma.jpg",
		link: "https://figma.com/",
		alt: "Figma"
	},
	{	src: "img/bookmarks/github.jpg",
		link: "https://github.com/",
		alt: "Github"
	},
   {	src: "img/bookmarks/salesforce.jpg",
		link: "https://www.salesforce.com/",
		alt: "Salesforce"
	},
   {	src: "img/bookmarks/accoustic.jpg",
		link: "https://www.acoustic.com/",
		alt: "Accoustic"
	},
   {	src: "img/bookmarks/braze.jpg",
		link: "https://www.braze.com/",
		alt: "Braze"
	},
	{
		src: "img/bookmarks/adobecampaign.jpg",
		link: "https://workfront.com/",
		alt: "Adobe Campaign"
  },
   {	src: "img/bookmarks/wiki.jpg",
		link: "https://www.atlassian.com/software/confluence",
		alt: "Confluence Documentation"
	},
   {	src: "img/bookmarks/wiki.jpg",
		link: "https://www.atlassian.com/software/confluence",
		alt: "Confluence Documentation"
	},
   {	src: "img/bookmarks/wiki.jpg",
		link: "https://www.atlassian.com/software/confluence",
		alt: "Confluence Documentation"
	},
   {	src: "img/bookmarks/wiki.jpg",
		link: "https://www.atlassian.com/software/confluence",
		alt: "Confluence Documentation"
	},
   {	src: "img/bookmarks/wiki.jpg",
		link: "https://www.atlassian.com/software/confluence",
		alt: "Confluence Documentation"
	},
   {	src: "img/bookmarks/wiki.jpg",
		link: "https://www.atlassian.com/software/confluence",
		alt: "Confluence Documentation"
	},
   {	src: "img/bookmarks/wiki.jpg",
		link: "https://www.atlassian.com/software/confluence",
		alt: "Confluence Documentation"
	},
   {	src: "img/bookmarks/wiki.jpg",
		link: "https://www.atlassian.com/software/confluence",
		alt: "Confluence Documentation"
	},
   {	src: "img/bookmarks/wiki.jpg",
		link: "https://www.atlassian.com/software/confluence",
		alt: "Confluence Documentation"
	},
   {	src: "img/bookmarks/wiki.jpg",
		link: "https://www.atlassian.com/software/confluence",
		alt: "Confluence Documentation"
	},
   {	src: "img/bookmarks/wiki.jpg",
		link: "https://www.atlassian.com/software/confluence",
		alt: "Confluence Documentation"
	},
   {	src: "img/bookmarks/wiki.jpg",
		link: "https://www.atlassian.com/software/confluence",
		alt: "Confluence Documentation"
	}
];

const bookmarksInner = document.getElementById('bookmarks-inner');

addBookmarks.forEach(bookmark => {
  const bookmarksWrapper = document.createElement('div');
  bookmarksWrapper.classList.add('col-4', 'col-sm-2', 'col-md-2', 'col-lg-3', 'col-xl-2', 'p-3');

  const bookmarkImage = document.createElement('img');
  bookmarkImage.src = bookmark.src;
  bookmarkImage.alt = bookmark.alt;
  bookmarkImage.classList.add('bookmark-image');

  // Store bookmark data as data attributes
  if (bookmark.links) {
    bookmarkImage.dataset.links = JSON.stringify(bookmark.links); // Store as JSON string
  } else if (bookmark.link) {
    bookmarkImage.dataset.link = bookmark.link;
  }

  bookmarksWrapper.appendChild(bookmarkImage);
  bookmarksInner.appendChild(bookmarksWrapper);
});


/*-- Open Links --*/
document.querySelectorAll('.bookmark-image').forEach(bookmarkImage => {
  bookmarkImage.addEventListener('click', (event) => {
    event.preventDefault(); // Prevent default link behavior

    if (bookmarkImage.dataset.links) {
      const links = JSON.parse(bookmarkImage.dataset.links); // Parse JSON string
      links.forEach(link => {
        window.open(link, '_blank');
      });
    } else if (bookmarkImage.dataset.link) {
      window.open(bookmarkImage.dataset.link, '_blank');
    }
  });
});

/*==========================
 Bookmarks Custom Tooltip
 ==========================*/
 document.addEventListener('mouseover', (event) => {
	const target = event.target;
	if (target.classList.contains('bookmark-image')) {
	  const tooltip = document.getElementById('bookmarks-tooltip');
	  tooltip.textContent = target.alt;
	  tooltip.style.visibility = 'visible';
	}
 });
 
 document.addEventListener('mouseout', (event) => {
	const target = event.target;
	if (target.classList.contains('bookmark-image')) {
	  const tooltip = document.getElementById('bookmarks-tooltip');
	  tooltip.textContent = '';
	  tooltip.style.visibility = 'hidden';
	}
 });