/*==========================
Client Review Bookmarks
==========================*/
const addBookmarksReviews = [
	{
		src: "img/bookmarks/workfrontmain.jpg",
		link: "https://workfront.com/",
		alt: "Adobe Workfront"
  },
	{  src: "img/bookmarks/w3c.jpg",
		 link: "https://validator.w3.org/",
		 alt: "W3C Markup Validation"
	},
	{  src: "img/bookmarks/qctool.jpg",
		 link: "https://qc.com/",
		 alt: "Quality Control Tool"
	},
	{  src: "img/bookmarks/diffcheck.jpg",
		link: "https://www.diffchecker.com/",
		alt: "Diff Check"
	},
	{  src: "img/bookmarks/tinypng.jpg",
		 link: "https://tinypng.com/",
		 alt: "Tiny PNG"
	},
	{  src: "img/bookmarks/imageoptim.jpg",
		link: "https://imageoptim.com/mac",
		alt: "ImageOptim (Mac)"
	},
	{
		src: "img/bookmarks/workfront.jpg",
		link: "https://workfront.com/",
		alt: "Adobe Workfront 2"
	},
	{
		src: "img/bookmarks/1V-IIR.jpg",
		links: ["https://wikipedia.org", "https://validator.w3.org/#validate_by_uri+with_options", "https://qctool.com"],
		alt: "1 File Dev Review"
	},
	{
		src: "img/bookmarks/2V-IIR.jpg",
		links: ["https://wikipedia.org", "https://validator.w3.org/#validate_by_uri+with_options", "https://qctool.com", "https://www.diffchecker.com/"],
		alt: "2 File Dev Review"
	},
	{
		src: "img/bookmarks/3V-IIR.jpg",
		links: ["https://wikipedia.org", "https://validator.w3.org/#validate_by_uri+with_options", "https://qctool.com", "https://www.diffchecker.com/", "https://www.diffchecker.com/"],
		alt: "3 File Dev Review"
	},
	{
		src: "img/bookmarks/7V-IIR.jpg",
		links: ["https://wikipedia.org", "https://validator.w3.org/#validate_by_uri+with_options", "https://qctool.com", "https://www.diffchecker.com/", "https://www.diffchecker.com/", "https://www.diffchecker.com/", "https://www.diffchecker.com/", "https://www.diffchecker.com/", "https://www.diffchecker.com/"],
		alt: "7 File Dev Review"
	},
	{
		src: "img/bookmarks/11V-IIR.jpg",
		links: ["https://wikipedia.org", "https://validator.w3.org/#validate_by_uri+with_options", "https://qctool.com", "https://www.diffchecker.com/", "https://www.diffchecker.com/", "https://www.diffchecker.com/", "https://www.diffchecker.com/", "https://www.diffchecker.com/", "https://www.diffchecker.com/", "https://www.diffchecker.com/", "https://www.diffchecker.com/", "https://www.diffchecker.com/", "https://www.diffchecker.com/"],
		alt: "11 File Dev Review"
  	},
];

const bookmarksReviewsInner = document.getElementById('bookmarks-reviews-inner'); // Unique ID

addBookmarksReviews.forEach(bookmarkReview => { // Unique variable name
	const bookmarksReviewsWrapper = document.createElement('div'); // Unique variable name
	bookmarksReviewsWrapper.classList.add('col-4', 'col-sm-2', 'col-md-2', 'col-lg-3', 'col-xl-2', 'p-3');

	const bookmarkReviewImage = document.createElement('img'); // Unique variable name
	bookmarkReviewImage.src = bookmarkReview.src;
	bookmarkReviewImage.alt = bookmarkReview.alt;
	bookmarkReviewImage.classList.add('bookmark-image-reviews'); // Unique class name

	if (bookmarkReview.links) {
		 bookmarkReviewImage.dataset.links = JSON.stringify(bookmarkReview.links);
	} else if (bookmarkReview.link) {
		 bookmarkReviewImage.dataset.link = bookmarkReview.link;
	}

	bookmarksReviewsWrapper.appendChild(bookmarkReviewImage);
	bookmarksReviewsInner.appendChild(bookmarksReviewsWrapper);
});


/*-- Open Links Reviews --*/
document.querySelectorAll('.bookmark-image-reviews').forEach(bookmarkReviewImage => { // Unique selector
	bookmarkReviewImage.addEventListener('click', (event) => {
		 event.preventDefault();

		 if (bookmarkReviewImage.dataset.links) {
			  const links = JSON.parse(bookmarkReviewImage.dataset.links);
			  links.forEach(link => {
					window.open(link, '_blank');
			  });
		 } else if (bookmarkReviewImage.dataset.link) {
			  window.open(bookmarkReviewImage.dataset.link, '_blank');
		 }
	});
});

/*==========================
 Bookmarks Reviews Custom Tooltip
 ==========================*/
 document.addEventListener('mouseover', (event) => {
	const target = event.target;
	if (target.classList.contains('bookmark-image-reviews')) { // Unique class name
	  const tooltipReviews = document.getElementById('bookmarks-tooltip'); // Unique ID
	  tooltipReviews.textContent = target.alt;
	  tooltipReviews.style.visibility = 'visible';
	}
 });
 
 document.addEventListener('mouseout', (event) => {
	const target = event.target;
	if (target.classList.contains('bookmark-image-reviews')) { // Unique class name
	  const tooltipReviews = document.getElementById('bookmarks-tooltip'); // Unique ID
	  tooltipReviews.textContent = '';
	  tooltipReviews.style.visibility = 'hidden';
	}
 });
