const sourceCode = {
//FIRST CODE SNIPPET
"HTML 4.01 Transitional Doctype": `&lt;!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd"&gt;`,
	
//SECOND CODE SNIPPET
"Outlook Dark Mode Button": `Add code here.`,
	
//THIRD CODE SNIPPET
 "CSS Blend Modes (GMAILDARKIOS)": `&lt;!DOCTYPE HTML PUBLIC &quot;-//W3C//DTD HTML 4.01 Transitional//EN&quot; &quot;http://www.w3.org/TR/html4/loose.dtd&quot;&gt;
&lt;html lang=&quot;en&quot;&gt;
&lt;head&gt;
&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;
&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width, initial-scale=1.0&quot;&gt;
&lt;title&gt;Gmail, Dark Mode and CSS Blend Modes&lt;/title&gt;
&lt;style&gt;
div { flex-grow:1; }
u + .body .gmail-blend-screen { background:#000; mix-blend-mode:screen; }
u + .body .gmail-blend-difference { background:#000; mix-blend-mode:difference; }
&lt;/style&gt;
&lt;/head&gt;
&lt;body class=&quot;body&quot; style=&quot;margin:0; padding:0; background:#000; font:1em/1.5 sans-serif;&quot; cz-shortcut-listen=&quot;true&quot;&gt;
&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;width:100%;&quot;&gt;
&lt;tr&gt;
 &lt;td&gt;
  &lt;div style=&quot;background:#00f; background-image:linear-gradient(#00f,#00f);&quot;&gt;
   &lt;div class=&quot;gmail-blend-screen&quot;&gt;
    &lt;div class=&quot;gmail-blend-difference&quot;&gt;
     &lt;p style=&quot;margin:0; padding:1em; color:#fff; font:bold 2em/1.5 sans-serif; text-align:center;&quot;&gt;CONTENT&lt;/p&gt;
    &lt;/div&gt;
   &lt;/div&gt;
  &lt;/div&gt;
 &lt;/td&gt;
&lt;/tr&gt;
&lt;/table&gt;
&lt;/body&gt;
&lt;/html&gt;`,

//FOURTH CODE SNIPPET
"Span + Non-Breaking Space": `&lt;span&gt;&amp;nbsp;&lt;/span&gt;`,

//FIFTH CODE SNIPPET
"Snippet Example": `Prepare &lt;HTML&gt; for a code snippet!`,

//SIXTH CODE SNIPPET
"Snippet Examples": `Prepare &lt;HTML&gt; for a code snippet!`,
	 
//SEVENTH CODE SNIPPET
"Snippets Example": `Prepare &lt;HTML&gt; for a code snippet!`,

//EIGTH CODE SNIPPET
"Snippets Examples": `Prepare &lt;HTML&gt; for a code snippet!`,
	 
//NINTH CODE SNIPPET
"Snippet Example Last": `Prepare &lt;HTML&gt; for a code snippet!`,

 };
 
 // Function to create a new accordion item and append it to the target container
 function createAccordionItem(containerId, id, title, sourceCode) {
	const accordionItem = document.createElement('div');
	accordionItem.classList.add('accordion-item');
 
	const accordionHeader = document.createElement('h2');
	accordionHeader.classList.add('accordion-header');
 
	const accordionButton = document.createElement('button');
	accordionButton.classList.add('accordion-button', 'collapsed');
	accordionButton.type = 'button';
	accordionButton.setAttribute('data-bs-toggle', 'collapse');
	accordionButton.setAttribute('data-bs-target', `#${id}`);
	accordionButton.setAttribute('aria-expanded', 'false');
	accordionButton.setAttribute('aria-controls', id);
	accordionButton.textContent = title;
 
	const accordionBody = document.createElement('div');
	accordionBody.id = id;
	accordionBody.classList.add('accordion-collapse', 'collapse');
	accordionBody.innerHTML = `<div class="accordion-body"><pre><div class="copy-container"><button class="copy-icon bi bi-copy"></button></div><code>${sourceCode}</code></pre></div>`;
	
 
	accordionHeader.appendChild(accordionButton);
	accordionItem.appendChild(accordionHeader);
	accordionItem.appendChild(accordionBody);
 
	const targetContainer = document.getElementById(containerId);
	if (targetContainer) {
	  targetContainer.appendChild(accordionItem);
	} else {
	  console.error(`Container with ID "${containerId}" not found.`);
	}
 }
 
// Assuming you have existing accordion containers with IDs:
const accordionMain1 = document.getElementById('accordionMain-1');
const accordionMain2 = document.getElementById('accordionMain-2');
const accordionMain3 = document.getElementById('accordionMain-3');
const accordionMain4 = document.getElementById('accordionMain-4');
const accordionMain5 = document.getElementById('accordionMain-5');
 
// Create and append accordion items to the appropriate containers
 
//  let itemCount = 1;
// for (const [language, code] of Object.entries(sourceCode)) {
// 	let targetContainer;
// 	if (itemCount <= 6) {
// 	  targetContainer = accordionMain1;
// 	} else if (itemCount <= 12) {
// 	  targetContainer = accordionMain2;
// 	} else if (itemCount <= 18) {
// 	  targetContainer = accordionMain3;
// 	} else if (itemCount <= 24) {
// 		targetContainer = accordionMain4;
// 	} else if (itemCount <= 30) {
// 		targetContainer = accordionMain5;
// 	}
// 	else {
// 	  // Handle items outside defined ranges (optional)
// 	}
// 	createAccordionItem(targetContainer.id, `collapse-${itemCount}`, language, code);
// 	itemCount++;
//  }

let itemCount = 1;
const overflowMessage = document.getElementById('overflow-message'); //Over 30 accordions
for (const [language, code] of Object.entries(sourceCode)) {
  const containerIndex = Math.floor((itemCount - 1) / 6); // Calculate container index
  const targetContainer = `accordionMain-${containerIndex + 1}`; // Construct container ID

  // Check if targetContainer is within defined ranges (1-5)
  if (containerIndex >= 0 && containerIndex < 5) {
    createAccordionItem(targetContainer, `collapse-${itemCount}`, language, code);
  } else {
	  // Handle items outside defined ranges
	  if (overflowMessage) { // Check if the element exists
      overflowMessage.style.display = 'block';
    } else {
      console.error("Overflow message element not found!");
    }
  }
  itemCount++;
}


 
 
 
 /////////////////
 //DON'T DISPLAY A CAROUSEL INDICATOR IF THERE AREN'T ANY ACCORDION ITEMS IN IT
 ////////////////
 // Get all accordionMain containers and indicator buttons
 const accordionContainers = document.querySelectorAll('.accordion');
 const indicatorButtons = document.querySelectorAll('.carousel-indicators.accordion-indicator button');
 
 // Function to check if an accordion container has content
 function hasContent(container) {
	return container.querySelector('*') !== null;
 }
 
 // Function to update the visibility of indicator buttons
 function updateIndicatorButtons() {
	indicatorButtons.forEach((button, index) => {
	  const container = accordionContainers[index];
	  if (hasContent(container)) {
		 button.classList.remove('d-none'); // Show the button
	  } else {
		 button.classList.add('d-none'); // Hide the button
	  }
	});
 }
 
 // Call the update function on page load
 updateIndicatorButtons();
 
 // Optionally, call the update function again after any dynamic changes to the accordion content
 // (e.g., when adding or removing items)
 
 
 
 /////////////////
 //SET MIN HEIGHT OF ACCORDION CAROUSEL BASED ON THE HEIGHT OF FIRST ACCORDION
 /////////////////
 // Get all elements with the class 'accordion'
 const accordions = document.querySelectorAll('.accordion');
 
 // Get the height of the first accordion
 const firstAccordionHeight = accordions[0].offsetHeight;
 
 // Set the min-height for all accordions
 accordions.forEach(accordion => {
	accordion.style.minHeight = `${firstAccordionHeight}px`;
 });


/*==========================
Click To Copy Code
==========================*/
const copyButtons = document.querySelectorAll('.copy-icon');

copyButtons.forEach(copyIconButton => {
  copyIconButton.addEventListener('click', async () => {
    const codeElement = copyIconButton.closest('pre').querySelector('code');
    const text = codeElement.textContent;

    try {
      await navigator.clipboard.writeText(text);
      copyIconButton.classList.add('copied');
      setTimeout(() => {
        copyIconButton.classList.remove('copied');
      }, 1000);
    } catch (err) {
      console.error('Failed to copy text:', err);
    }
  });
});