const eventCountdownContainer = document.getElementById('event-countdown-container');
const eventScheduleTableBody = document.getElementById('event-schedule-table').querySelector('tbody');

const eventEvents = [
    { date: "2025-01-02T10:00:00Z", name: "No Event Topic Yet", presenter: "No Presenter Yet"},
    { date: "2025-01-16T10:00:00Z", name: "No Event Topic Yet", presenter: "No Presenter Yet"},
    { date: "2025-01-30T10:00:00Z", name: "No Event Topic Yet", presenter: "No Presenter Yet"},
    { date: "2025-02-13T10:00:00Z", name: "No Event Topic Yet", presenter: "No Presenter Yet"},
    { date: "2025-02-27T10:00:00Z", name: "No Event Topic Yet", presenter: "No Presenter Yet"},
    { date: "2025-03-13T10:00:00Z", name: "No Event Topic Yet", presenter: "No Presenter Yet"},
    { date: "2025-03-27T10:00:00Z", name: "No Event Topic Yet", presenter: "No Presenter Yet"},
    { date: "2025-04-10T10:00:00Z", name: "No Event Topic Yet", presenter: "No Presenter Yet"},
    { date: "2025-04-24T10:00:00Z", name: "No Event Topic Yet", presenter: "No Presenter Yet"},
    { date: "2025-05-08T10:00:00Z", name: "No Event Topic Yet", presenter: "No Presenter Yet"},
    { date: "2025-06-05T10:00:00Z", name: "No Event Topic Yet", presenter: "No Presenter Yet"},
    { date: "2025-06-19T10:00:00Z", name: "No Event Topic Yet", presenter: "No Presenter Yet"},
    { date: "2025-07-03T10:00:00Z", name: "No Event Topic Yet", presenter: "No Presenter Yet"},
    { date: "2025-07-17T10:00:00Z", name: "No Event Topic Yet", presenter: "No Presenter Yet"},
    { date: "2025-07-31T10:00:00Z", name: "No Event Topic Yet", presenter: "No Presenter Yet"},
    { date: "2025-08-14T10:00:00Z", name: "No Event Topic Yet", presenter: "No Presenter Yet"},
    { date: "2025-08-28T10:00:00Z", name: "No Event Topic Yet", presenter: "No Presenter Yet"},
    { date: "2025-09-11T10:00:00Z", name: "No Event Topic Yet", presenter: "No Presenter Yet"},
    { date: "2025-09-25T10:00:00Z", name: "No Event Topic Yet", presenter: "No Presenter Yet"},
    { date: "2025-10-09T10:00:00Z", name: "No Event Topic Yet", presenter: "No Presenter Yet"},
    { date: "2025-10-23T10:00:00Z", name: "No Event Topic Yet", presenter: "No Presenter Yet"},
    { date: "2025-11-06T10:00:00Z", name: "No Event Topic Yet", presenter: "No Presenter Yet"},
    { date: "2025-11-20T10:00:00Z", name: "No Event Topic Yet", presenter: "No Presenter Yet"},
    { date: "2025-12-04T10:00:00Z", name: "No Event Topic Yet", presenter: "No Presenter Yet"},
    { date: "2025-12-18T10:00:00Z", name: "No Event Topic Yet", presenter: "No Presenter Yet"},
];

function updateeventCountdown() {
    const eventNow = new Date();
    let todayEvent = null;
    let eventNextEvent = null;
    let eventTimeDiff = Infinity;

    for (const eventEvent of eventEvents) {
        const eventEventDate = new Date(eventEvent.date); // Directly parse ISO 8601

        if (isNaN(eventEventDate.getTime())) {
            console.error(`Invalid date: ${eventEvent.date}`);
            continue;
        }

        if (eventEventDate.getFullYear() === eventNow.getFullYear() &&
            eventEventDate.getMonth() === eventNow.getMonth() &&
            eventEventDate.getDate() === eventNow.getDate()) {
            todayEvent = eventEvent;
            break;
        }

        const eventDiff = eventEventDate.getTime() - eventNow.getTime();

        if (eventDiff > 0 && eventDiff < eventTimeDiff) {
            eventTimeDiff = eventDiff;
            eventNextEvent = eventEvent;
        }
    }

    if (todayEvent) {
        eventCountdownContainer.innerHTML = `
            <div class="event-countdown">
                <h4 class="gray-title mt-3 mb-2">There is a Dev event <span class="event-today">today</span>!</h4>
                     <h4 class="gray-title mt-3 mb-2">Topic: <span class="event-topic">${todayEvent.name}</span></h4>
                     <h4 class="gray-title mt-3 mb-2">Presenter: <span class="event-presenter">${todayEvent.presenter}</span></h4>
            </div>`;
    } else if (eventNextEvent) {
        const eventDays = Math.ceil(eventTimeDiff / (1000 * 60 * 60 * 24));
        let daysText = "Days";
        if (eventDays === 1) {
            daysText = "Day";
        }
        eventCountdownContainer.innerHTML = `
            <div class="event-countdown">
                <h4 class="gray-title mt-3 mb-2">Next Dev event is in <span class="event-days">${eventDays}</span> ${daysText}</h4>
                <h4 class="gray-title mt-3 mb-2">Topic: <span class="event-topic">${eventNextEvent.name}</span></h4>
                     <h4 class="gray-title mt-3 mb-2">Presenter: <span class="event-presenter">${eventNextEvent.presenter}</span></h4>
            </div>`;
    } else {
        eventCountdownContainer.innerHTML = "<div class='event-countdown'>No upcoming events found.</div>";
    }
}

function displayeventSchedule() {
    eventScheduleTableBody.innerHTML = "";
    const now = new Date();
    eventEvents.sort((a, b) => {
        return new Date(a.date) - new Date(b.date);
    });

    let nextEventFound = false;
    let todayEventFound = false;

    eventEvents.forEach(eventEvent => {
        const row = eventScheduleTableBody.insertRow();
        const dateCell = row.insertCell();
        const topicCell = row.insertCell();
        const presenterCell = row.insertCell();
        const eventDate = new Date(eventEvent.date);
        const formattedDate = (eventDate.getMonth() + 1) + '/' + eventDate.getDate() + '/' + eventDate.getFullYear();

        dateCell.textContent = formattedDate;
        topicCell.textContent = eventEvent.name;
        presenterCell.textContent = eventEvent.presenter;

        // Check if the event is happening today
        if (eventDate.getFullYear() === now.getFullYear() &&
            eventDate.getMonth() === now.getMonth() &&
            eventDate.getDate() === now.getDate()) {
            row.classList.add("next-event-row");
            todayEventFound = true;
        }

        // Check for the next event after today, but only if no event is happening today
        else if (!todayEventFound && eventDate >= now && !nextEventFound) {
            row.classList.add("next-event-row");
            nextEventFound = true;
        }
    });
}

// Initial calls and interval
updateeventCountdown();
displayeventSchedule();
setInterval(updateeventCountdown, 1000);