// (function(window, document) {
//   // First textarea - decodedTextareaId
//   // Second textarea - encodedTextareaId

//   var decodedTextarea = document.getElementById('decodedTextAreaID1');
//   var encodedTextarea = document.getElementById('encodedTextAreaID1');

//   /* Permalink generator
//   function encode(string) {
//     return encodeURIComponent(string).replace(/['()_*]/g, function(character) {
//       return '%' + character.charCodeAt().toString(16);
//     });
//   } */

//   function update() {
//     var shouldDecode = this == encodedTextarea;
//     var value;
//     if (shouldDecode) {
//       value = he.decode(encodedTextarea.value);
//       decodedTextarea.value = value;
//     } else {
//       value = he.encode(decodedTextarea.value, {
//         'encodeEverything': true, // Always encode everything
//         'useNamedReferences': true // Always use named references
//       });
//       encodedTextarea.value = value;
//     }
//   };

//   decodedTextarea.oninput = encodedTextarea.oninput = function() {
//     update.call(this);
//   };

//   decodedTextarea.oninput(); // Initial update



//   // Add click event listener for the copy button
//     copyEntitiesButton.addEventListener('click', function() {
//       var encodedText = encodedTextarea.value;
//       navigator.clipboard.writeText(encodedText)
//         .then(() => {
//           console.log('Encoded text copied to clipboard!');
//         })
//         .catch(err => {
//           console.error('Failed to copy text:', err);
//         });
//     });
  


// }(this, document));








(function(window, document) {
  // First textarea - decodedTextareaId
  var decodedTextArea1 = document.getElementById('decodedTextAreaID1');
  var encodedTextArea1 = document.getElementById('encodedTextAreaID1');
  var copyEntitiesButton1 = document.getElementById('copyEntitiesButton1'); // First copy button

  // Second textarea - decodedTextAreaID2 and encodedTextAreaID2
  var decodedTextArea2 = document.getElementById('decodedTextAreaID2');
  var encodedTextArea2 = document.getElementById('encodedTextAreaID2');
  var copyEntitiesButton2 = document.getElementById('copyEntitiesButton2'); // Second copy button


  function update(textArea1, textArea2, encodeSettings) {
      var shouldDecode = textArea1 === encodedTextArea1 || textArea1 === encodedTextArea2;
      var value;
      if (shouldDecode) {
          value = he.decode(textArea1.value);
          textArea2.value = value;
      } else {
          value = he.encode(textArea1.value, encodeSettings);
          textArea2.value = value;
      }
  };

  // Update function for first textarea pair
  decodedTextArea1.oninput = encodedTextArea1.oninput = function() {
      update(this, encodedTextArea1, {
          'encodeEverything': true,
          'useNamedReferences': true
      });
  };

  decodedTextArea1.oninput(); // Initial update for first pair

  // Update function for second textarea pair
  decodedTextArea2.oninput = encodedTextArea2.oninput = function() {
      update(this, encodedTextArea2, {
          'encodeEverything': false,
          'useNamedReferences': true
      });
  };

  decodedTextArea2.oninput(); // Initial update for second pair

  // Copy to clipboard function (reusable)
  function copyToClipboard(text, message) {
      navigator.clipboard.writeText(text)
          .then(() => {
              console.log(message + ' copied to clipboard!');
          })
          .catch(err => {
              console.error('Failed to copy text:', err);
          });
  }

  // Add click event listener for the first copy button
  copyEntitiesButton1.addEventListener('click', function() {
      copyToClipboard(encodedTextArea1.value, "Encoded text 1");
  });

  // Add click event listener for the second copy button
  copyEntitiesButton2.addEventListener('click', function() {
      copyToClipboard(encodedTextArea2.value, "Encoded text 2");
  });

}(this, document));









/*-- Make Textarea Resize Handle Full Width --*/
const textareaContainers = document.querySelectorAll('.textarea-container'); // Select all containers

textareaContainers.forEach(textareaContainer => { // Loop through each container
    const textarea = textareaContainer.querySelector('textarea');
    const resizeHandle = textareaContainer.querySelector('.resize-handle');

    if (!textarea || !resizeHandle) {
        // console.error("Textarea or resize handle not found in container.");
        return; // Skip if elements are not found
    }

    let initialHeight;
    let mouseY;

    resizeHandle.addEventListener('mousedown', (e) => {
        initialHeight = textarea.clientHeight;
        mouseY = e.clientY;
        document.addEventListener('mousemove', onMouseMove);
        document.addEventListener('mouseup', onMouseUp);
    });

    const onMouseMove = (e) => {
        const deltaY = e.clientY - mouseY;
        const newHeight = initialHeight + deltaY;
        textarea.style.height = Math.max(0, newHeight) + 'px';
    };

    const onMouseUp = () => {
        document.removeEventListener('mousemove', onMouseMove);
        document.removeEventListener('mouseup', onMouseUp);
    };
});



//Make Green and Remove Green Focus From Copy Entities Button
function addCopyHighlighting(encodedButtonID) {
    const encodedTextAreaID = encodedButtonID.replace("copyEntitiesButton", "encodedTextAreaID");
    const encodedTextArea = document.getElementById(encodedTextAreaID);
    const encodedCopyButton = document.getElementById(encodedButtonID);

    if (!encodedCopyButton) {
        console.error(`Button with ID '${encodedButtonID}' not found.`);
        return;
    }

    encodedCopyButton.addEventListener('click', () => {
        if (encodedTextArea && encodedTextArea.value.trim() !== "") { // Check if not empty
            encodedTextArea.classList.add('copy-highlight');
            encodedCopyButton.classList.add('copy-highlight');

            setTimeout(() => {
                encodedTextArea.classList.remove('copy-highlight');
                encodedCopyButton.classList.remove('copy-highlight');
            }, 1400);
        } else {
            console.log("TextArea is empty, no highlighting added.");
        }
    });
}

addCopyHighlighting('copyEntitiesButton1');
addCopyHighlighting('copyEntitiesButton2');


/*Move Carot Cursor To End of textarea on load  ***creates issue with scrolling to this section on refresh***
window.addEventListener('load', () => {
  const textarea = document.getElementById('decodedTextAreaID1');
  textarea.setSelectionRange(textarea.value.length, textarea.value.length); 
});
*/