const resizableDiv = document.getElementById("myResizableDiv");
const resizeHandle = resizableDiv.querySelector(".render-resize-handle");
const scrollableContent = resizableDiv.querySelector(".scrollable-content");
let isResizing = false;
let startY;
let startHeight;

resizeHandle.addEventListener("mousedown", (e) => {
    isResizing = true;
    startY = e.clientY;
    startHeight = resizableDiv.offsetHeight;
    document.addEventListener("mousemove", resize);
    document.addEventListener("mouseup", stopResize);
});

function resize(e) {
    if (!isResizing) return;
    const newHeight = startHeight + (e.clientY - startY);
    resizableDiv.style.height = `${newHeight}px`;
    scrollableContent.style.height = `${newHeight}px`;
}

function stopResize() {
    isResizing = false;
    document.removeEventListener("mousemove", resize);
    document.removeEventListener("mouseup", stopResize);
}

const tableBody = document.getElementById("renderDataTable").getElementsByTagName("tbody")[0];
const renderSearchInput = document.getElementById("renderSearchInput");

let renderFixData = [
    {
        clientSpecific: "N/A",
        emailClient: "iPhone 14 Dark Mode",
        description: "The iPhone 14 doesn't render plain white #ffffff in dark mode for background colors.<br><br>Use #fffffe in a dark mode query instead.",
        codeExample: `&lt;a href=&quot;#&quot; class=&quot;my-cta&quot;&gt;Dark Mode CTA&lt;/a&gt;
&lt;style&gt;
  @media (prefers-color-scheme: dark) {
    .my-cta { background-color: #FFFFFE !important; }
    [data-ogsb] .my-cta { background-color: #FFFFFE !important; }
  }
&lt;/style&gt;`,
    },
    {
        clientSpecific: "Sharper Image",
        emailClient: "Windows Outlook Dark Mode",
        description: "Windows Outlook Dark Mode inverts the font color on background images making it illegible.",
        codeExample: `&lt;p&gt;This is &lt;strong&gt;example 2&lt;/strong&gt;.&lt;/p&gt;`,
    },
    {
        clientSpecific: "Hot Topic",
        emailClient: "Yahoo & AOL",
        description: "Font weight & display: none; issues. Lorem Ipsum is dummy text of the printing industry.",
        codeExample: `&lt;p&gt;This is &lt;strong&gt;example 1&lt;/strong&gt;.&lt;/p&gt;`,
    },
    {
        clientSpecific: "Spencer's Gifts",
        emailClient: "Microsoft Outlook 2016",
        description: "It's Windows Outlook 2016. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s.",
        codeExample: `&lt;p&gt;This is &lt;strong&gt;example 1&lt;/strong&gt;.&lt;/p&gt;`,
    },
    {
        clientSpecific: "N/A",
        emailClient: "iPhone 27",
        description: "The iPhone 27..",
        codeExample: `&lt;p&gt;This is &lt;strong&gt;example 3&lt;/strong&gt;.&lt;/p&gt;`,
    },
    {
        clientSpecific: "N/A",
        emailClient: "iPhone 28",
        description: "The iPhone 28..",
        codeExample: `&lt;p&gt;This is &lt;strong&gt;example 4&lt;/strong&gt;.&lt;/p&gt;`,
    },
    {
        clientSpecific: "N/A",
        emailClient: "iPhone 39",
        description: "The iPhone 39..",
        codeExample: `&lt;p&gt;This is &lt;strong&gt;example 5&lt;/strong&gt;.&lt;/p&gt;`,
    },
    {
        clientSpecific: "N/A",
        emailClient: "iPhone 60",
        description: "The iPhone 60..",
        codeExample: `&lt;p&gt;This is &lt;strong&gt;example 6&lt;/strong&gt;.&lt;/p&gt;`,
    },
];

function populateTable(data) {
    tableBody.innerHTML = "";
    data.forEach(item => {
        const row = tableBody.insertRow();
        const clientSpecificCell = row.insertCell();
        const emialClientCell = row.insertCell();
        const descriptionCell = row.insertCell();
        const codeExampleCell = row.insertCell();

        clientSpecificCell.textContent = item.clientSpecific;
        emialClientCell.textContent = item.emailClient;

        const descriptionDiv = document.createElement('div');
        descriptionDiv.classList.add('html-content');
        descriptionDiv.innerHTML = item.description;
        descriptionCell.appendChild(descriptionDiv);

        let codeExampleContent = item.codeExample;

        const codeExampleDiv = document.createElement('div');
        codeExampleDiv.innerHTML = `<pre><code class="language-html">${codeExampleContent}</code></pre>`;
        codeExampleCell.appendChild(codeExampleDiv);

        const copyButton = document.createElement('button');
        copyButton.classList.add('render-copy-icon', 'bi', 'bi-copy');
        codeExampleCell.appendChild(copyButton);

        // Add position: relative; to the codeExampleCell
        codeExampleCell.style.position = 'relative';
    });
    hljs.highlightAll();
    addCopyToClipboardListeners();
}

function addCopyToClipboardListeners() {
    const copyButtons = document.querySelectorAll('.render-copy-icon.bi-copy');

    copyButtons.forEach(copyButton => {
        copyButton.addEventListener('click', async () => {
            const codeElement = copyButton.previousElementSibling.querySelector('code');
            const text = codeElement.textContent;

            try {
                await navigator.clipboard.writeText(text);
                copyButton.classList.add('copied');
                setTimeout(() => {
                    copyButton.classList.remove('copied');
                }, 1000);
            } catch (err) {
                console.error('Failed to copy text:', err);
            }
        });
    });
}

function highlightSearch(searchTerm) {
    const rows = tableBody.getElementsByTagName('tr');
    for (let i = 0; i < rows.length; i++) {
        const cells = rows[i].getElementsByTagName('td');
        for (let j = 0; j < cells.length; j++) {
            const cell = cells[j];
            if (j !== 3) {
                if (cell.firstChild && cell.firstChild.nodeType === Node.TEXT_NODE) {
                    const text = cell.firstChild.nodeValue;
                    if (text) {
                        const highlightedText = text.replace(new RegExp(searchTerm, 'gi'), match => `<span class="highlight">${match}</span>`);
                        cell.innerHTML = highlightedText;
                    }
                } else if (cell.querySelector('.html-content')) {
                    const htmlContent = cell.querySelector('.html-content');
                    const text = htmlContent.innerHTML;
                    if (text) {
                        const highlightedText = text.replace(new RegExp(searchTerm, 'gi'), match => `<span class="highlight">${match}</span>`);
                        htmlContent.innerHTML = highlightedText;
                    }
                }
            }
        }
    }
}

populateTable(renderFixData);

renderSearchInput.addEventListener("keyup", function() {
    const searchTerm = renderSearchInput.value.toLowerCase();
    const filteredData = renderFixData.filter(item => {
        for (const key in item) {
            if (key !== "codeExample" && item[key] && item[key].toString().toLowerCase().includes(searchTerm)) {
                return true;
            }
        }
        return false;
    });
    populateTable(filteredData);
    if (searchTerm) {
        highlightSearch(renderSearchInput.value);
    }

    if (filteredData.length === 0) {
        showNoResults();
    } else {
        hideNoResults();
    }
});

function showNoResults() {
    document.getElementById('renderDataTable').style.display = 'none';
    document.getElementById('noRenderResults').style.display = 'block';
}

function hideNoResults() {
    document.getElementById('renderDataTable').style.display = 'table';
    document.getElementById('noRenderResults').style.display = 'none';
}

hljs.highlightAll();