/*==========================
Force Refresh at top of page (Bootstrap Scrollspy is buggy)
==========================*/
document.addEventListener('DOMContentLoaded', function () {
  window.scrollTo(0, 0); // Scroll to top when content has loaded
});


/*==========================
Bootstrap Tooltip
==========================*/
// Assign all attribute/value pairs to variable
const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]')
// "..." spread syntax to convert DOM element node list (variable above) into an array[]. Then .map() a new array 
const tooltipList = [...tooltipTriggerList].map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl))


/*==========================
Light Mode Switch
==========================*/
//*Light Mode Switch (changed to start off with dark mode)
//https://github.com/coliff/dark-mode-switch/
var toggle = document.getElementById("toggle"); //doesn't like let/const?
window.addEventListener("load", (function() {
    if (toggle) {
        initTheme();
        toggle.addEventListener("change", (function() {
            resetTheme()
        }))
    }
}));
function initTheme() {
    var lightThemeSelected = localStorage.getItem("toggle") !== null && localStorage.getItem("toggle") === "light";
    toggle.checked = lightThemeSelected;
    lightThemeSelected ? document.body.setAttribute("data-theme", "light") : document.body.removeAttribute("data-theme")
}
function resetTheme() {
    if (toggle.checked) {
        document.body.setAttribute("data-theme", "light");
        localStorage.setItem("toggle", "light")
    } else {
        document.body.removeAttribute("data-theme");
        localStorage.removeItem("toggle")
    }
}


//== Top Scroll Button jQuery ==//
$(window).scroll(function () {
	if ($(this).scrollTop() > 500) {
		$('.top-scroll').fadeIn();
	} else {
		$('.top-scroll').fadeOut();
	}
});


/*==========================
 Date & Time in Top Right
 ==========================*/
function displayDateTime() {
  const now = new Date();

  // Get weekday, date, and time components
  const weekday = now.toLocaleString('en-US', { weekday: 'long' });
  const year = now.getFullYear();
  const month = now.getMonth() + 1; // Months are 0-indexed
  const day = now.getDate();
  let hours = now.getHours();
  const minutes = now.getMinutes().toString().padStart(2, '0');
  const seconds = now.getSeconds().toString().padStart(2, '0');

  // Convert to 12-hour format
  const ampm = hours >= 12 ? 'PM' : 'AM';
  hours = hours % 12;
  hours = hours || 12; // Handle 0 o'clock (midnight)

  // Choose icon based on AM/PM
  const icon = ampm === 'AM' ? '\u2600' : '\u263E'; 

  // Format the date and time
  const formattedDate = `${weekday}, \u00A0 ${month}-${day}-${year} \u00A0 ${icon} ${hours}:${minutes}:${seconds}`;

  // Select all elements with the class 'datetime-display'
  const dateTimeElements = document.querySelectorAll('.datetime-display');

  // Update the text content of each element
  dateTimeElements.forEach(element => {
    element.textContent = formattedDate;
  });
}

// Call the function to display the initial date and time
displayDateTime();

// Update the display every second
setInterval(displayDateTime, 1000);


/*==========================
 Google Search Feature
==========================*/
const searchInput = document.getElementById('searchInput');
const searchButton = document.getElementById('searchButton');

// Add an event listener for the 'keydown' event
searchInput.addEventListener('keydown', (event) => {
  if (event.key === 'Enter') {
    const searchQuery = searchInput.value.trim(); // Trim to remove leading/trailing whitespace
    if (searchQuery) { // Check if the query is not empty
      const googleSearchUrl = `https://www.google.com/search?q=${searchQuery}`;
      window.open(googleSearchUrl, '_blank');
      searchInput.value = '';
    } else {
      // Prevent default form submission (if applicable)
      event.preventDefault();
    }
  }
});

// You can still keep the button click event if you prefer
searchButton.addEventListener('click', () => {
  const searchQuery = searchInput.value.trim();
  if (searchQuery) { // Check if the query is not empty
    const googleSearchUrl = `https://www.google.com/search?q=${searchQuery}`;
    window.open(googleSearchUrl, '_blank');
    searchInput.value = '';
  }
});


/*==========================
Blur Main Content on Sidebar Hover
==========================*/
const elementsToFade = document.querySelectorAll('.text-mode');
const hoverSidebar = document.querySelector('.sidebar-nav-inner');

hoverSidebar.addEventListener('mouseover', () => {
  elementsToFade.forEach(mouseHover => {
    mouseHover.classList.add('sidebar-fade');
  });
});

hoverSidebar.addEventListener('mouseout', () => {
  elementsToFade.forEach(mouseHover => {
    mouseHover.classList.remove('sidebar-fade');
  });
});


/*==========================
Cache Bookmark Section Carousel Slider Positions
==========================*/
function cacheActiveCarouselItem(carouselId) {
  const carouselItems = document.querySelectorAll(`#${carouselId} .carousel-inner .carousel-item`);
  const activeItem = document.querySelector(`#${carouselId} .carousel-inner .carousel-item.active`);

  console.log(`Carousel Items (${carouselId}):`, carouselItems);
  console.log(`Active Item (${carouselId}):`, activeItem);

  if (activeItem) {
    const activeIndex = Array.from(carouselItems).indexOf(activeItem);
    localStorage.setItem(`activeCarouselIndex_${carouselId}`, activeIndex);
    console.log(`Active Index (${carouselId}):`, activeIndex);
  } else {
    console.log(`No active item found (${carouselId}).`);
  }
}

function restoreActiveCarouselItem(carouselId) {
  const storedIndex = localStorage.getItem(`activeCarouselIndex_${carouselId}`);
  if (storedIndex !== null) {
    console.log(`Restoring carousel (${carouselId}) to index:`, storedIndex);
    const carouselInstance = new bootstrap.Carousel(document.querySelector(`#${carouselId}`));
    carouselInstance.to(parseInt(storedIndex));
  } else {
    console.log(`No stored carousel index found (${carouselId}).`);
  }
}

function initializeCarousel(carouselId) {
    const carouselElement = document.querySelector(`#${carouselId}`);
    if (carouselElement) {
        const carouselInstance = new bootstrap.Carousel(carouselElement);
        if (carouselInstance){
            console.log(`carousel (${carouselId}) initialized`);
        } else {
            console.log(`carousel (${carouselId}) failed to initialize`);
        }
    }
}

document.addEventListener('DOMContentLoaded', function() {
  const carouselIds = ['bookmarksWeatherCarousel', 'bookmarksColumnCarousel'];

  carouselIds.forEach(carouselId => {
    restoreActiveCarouselItem(carouselId);
    initializeCarousel(carouselId);

    const carousel = document.querySelector(`#${carouselId}`);
    if (carousel) {
      carousel.addEventListener('slid.bs.carousel', function(event) {
        console.log(`Carousel slide event fired (${carouselId}):`, event);
        cacheActiveCarouselItem(carouselId);
      });
    }
  });
});


/*==========================
Countdown Timer in Bookmarks Section
==========================*/
let countdownInterval = null;
let remainingTime;

const countdownDisplay = document.getElementById('countdown-display');
const countdownStartStopButton = document.getElementById('countdown-start-stop');
const countdownResetButton = document.getElementById('countdown-reset');
const countdownInputHours = document.getElementById('countdown-input-hours');
const countdownInputMinutes = document.getElementById('countdown-input-minutes');
const countdownInputSeconds = document.getElementById('countdown-input-seconds');
const finishSound = document.getElementById('finish-sound');

countdownStartStopButton.addEventListener('click', toggleCountdown);
countdownResetButton.addEventListener('click', resetCountdown);

function toggleCountdown() {
    if (countdownInterval) {
        stopCountdown();
    } else {
        startCountdown();
    }
}

function startCountdown() {
    if (typeof remainingTime === 'undefined') {
        let hours = parseInt(countdownInputHours.value) || 0;
        let minutes = parseInt(countdownInputMinutes.value) || 0;
        let seconds = parseInt(countdownInputSeconds.value) || 0;

        // Set default to 5 minutes if no input is provided
        if (hours === 0 && minutes === 0 && seconds === 0) {
            remainingTime = 15 * 60; // 15 minutes in seconds
        } else {
            remainingTime = hours * 3600 + minutes * 60 + seconds;
        }

        if (remainingTime <= 0) {
            countdownDisplay.textContent = "Finished!";
            playCountdownSound();
            return;
        }
        displayCountdownTime(remainingTime);
    }

    countdownStartStopButton.classList.add('running');
    countdownStartStopButton.textContent = "Stop";

    clearInterval(countdownInterval);
    countdownInterval = null;

    countdownInterval = setInterval(() => {
        remainingTime--;

        if (remainingTime < 0) {
            clearInterval(countdownInterval);
            countdownInterval = null;
            countdownDisplay.textContent = "Finished!";
            countdownStartStopButton.classList.remove('running');
            countdownStartStopButton.textContent = "Start";
            remainingTime = undefined;
            playCountdownSound();
            return;
        }

        displayCountdownTime(remainingTime);
    }, 1000);
}

function stopCountdown() {
    clearInterval(countdownInterval);
    countdownInterval = null;
    countdownStartStopButton.classList.remove('running');
    countdownStartStopButton.textContent = "Start";
}

function resetCountdown() {
    clearInterval(countdownInterval);
    countdownInterval = null;
    countdownDisplay.textContent = "00:00:00";
    countdownStartStopButton.classList.remove('running');
    countdownStartStopButton.textContent = "Start";
    countdownInputHours.value = '';
    countdownInputMinutes.value = '';
    countdownInputSeconds.value = '';
    remainingTime = undefined;
}

function displayCountdownTime(totalSeconds) {
    let seconds = totalSeconds % 60;
    let minutes = Math.floor(totalSeconds / 60) % 60;
    let hours = Math.floor(totalSeconds / 3600);

    seconds = seconds < 10 ? "0" + seconds : seconds;
    minutes = minutes < 10 ? "0" + minutes : minutes;
    hours = hours < 10 ? "0" + hours : hours;

    countdownDisplay.textContent = `${hours}:${minutes}:${seconds}`;
}

function playCountdownSound() {
    finishSound.play().catch(error => {
        console.error("Autoplay Error:", error);
        alert("Audio playback failed. Please interact with the page (e.g., click) to enable autoplay.");
    });
}


/*==========================
Stopwatch in Bookmarks Section
==========================*/
let stopwatchInterval = null;
let stopwatchTime = 0;
let hasStarted = false;

const stopwatchDisplay = document.getElementById('stopwatch-display');
const stopwatchStartStopButton = document.getElementById('stopwatch-start-stop');
const stopwatchResetButton = document.getElementById('stopwatch-reset');
const startSound = document.getElementById('start-sound');

stopwatchStartStopButton.addEventListener('click', toggleStopwatch);
stopwatchResetButton.addEventListener('click', resetStopwatch);

function toggleStopwatch() {
  if (stopwatchInterval) {
    stopStopwatch();
  } else {
    startStopwatch();
  }
}

function startStopwatch() {
  stopwatchStartStopButton.classList.add('running'); 
  stopwatchStartStopButton.textContent = "Stop";

  if (!hasStarted) { 
    playSound();
    hasStarted = true; 
  }

  stopwatchInterval = setInterval(() => {
    stopwatchTime += 10;
    displayTime();
  }, 10);
}

function stopStopwatch() {
  clearInterval(stopwatchInterval);
  stopwatchInterval = null;
  stopwatchStartStopButton.classList.remove('running');
  stopwatchStartStopButton.textContent = "Start";
}

function resetStopwatch() {
  clearInterval(stopwatchInterval);
  stopwatchInterval = null;
  stopwatchTime = 0;
  displayTime();
  stopwatchStartStopButton.classList.remove('running');
  stopwatchStartStopButton.textContent = "Start";
  hasStarted = false; 
}

function displayTime() {
  let milliseconds = stopwatchTime;
  let seconds = Math.floor((milliseconds / 1000) % 60);
  let minutes = Math.floor((milliseconds / (1000 * 60)) % 60);
  let hours = Math.floor((milliseconds / (1000 * 60 * 60)));
  let centiseconds = Math.floor((milliseconds % 1000) / 10);

  seconds = seconds < 10 ? "0" + seconds : seconds;
  minutes = minutes < 10 ? "0" + minutes : minutes;
  hours = hours < 10 ? "0" + hours : hours;
  centiseconds = centiseconds < 10 ? "0" + centiseconds : centiseconds;

  stopwatchDisplay.textContent = `${hours}:${minutes}:${seconds}.${centiseconds}`;
}

function playSound() {
  startSound.play().catch(error => {
    console.error("Autoplay Error:", error);
    alert("Audio playback failed. Please interact with the page (e.g., click) to enable autoplay.");
  });
}



/*==========================
Client Time Calculation in Bookmarks Section
==========================*/
const timeHistoryElement = document.getElementById('time-history');
let timeHistoryString = "";

function increment(timeValue) {
    const timeDisplay = document.getElementById('time-display');
    let currentTimeNumber = parseFloat(timeDisplay.value);
    currentTimeNumber += timeValue;
    timeDisplay.value = currentTimeNumber.toFixed(2);

    if (timeHistoryString === "") {
        timeHistoryString = timeValue.toFixed(2);
    } else {
        timeHistoryString += " + " + timeValue.toFixed(2);
    }

    timeHistoryElement.innerHTML = timeHistoryString + " = " + currentTimeNumber.toFixed(2);

    // Save to localStorage
    localStorage.setItem('timeDisplayValue', timeDisplay.value);
    localStorage.setItem('timeHistoryString', timeHistoryString);
}

function clearTimeDisplay() {
    const timeDisplay = document.getElementById('time-display');
    timeDisplay.value = "0";
    timeHistoryElement.innerHTML = "";
    timeHistoryString = "";

    // Clear localStorage
    localStorage.setItem('timeDisplayValue', timeDisplay.value);
    localStorage.setItem('timeHistoryString', timeHistoryString);
}

document.addEventListener('DOMContentLoaded', () => {
    const timeDisplay = document.getElementById('time-display');
    const storedDisplayValue = localStorage.getItem('timeDisplayValue');
    const storedHistoryString = localStorage.getItem('timeHistoryString');

    // Only set the value if there is a stored value
    if (storedDisplayValue !== null) {
        timeDisplay.value = storedDisplayValue;
    }

    if (storedHistoryString !== null) {
        timeHistoryString = storedHistoryString;
        timeHistoryElement.innerHTML = timeHistoryString + " = " + timeDisplay.value;
    }
});



/*==========================
Display Different Time Zones in Bookmarks Section
==========================*/
function getLocalTime(timezoneOffset) {
  const utcNow = new Date();
  const localOffset = utcNow.getTimezoneOffset() * 60000; // Offset in milliseconds
  const localTime = new Date(utcNow.getTime() + (timezoneOffset * 3600000) + localOffset); 
  return localTime;
}

function formatTimeZones(timeZones) {
  let hoursZones = timeZones.getHours();
  const ampmZones = hoursZones >= 12 ? 'PM' : 'AM';
  hoursZones = hoursZones % 12 || 12; // Convert to 12-hour format and handle midnight
  const minutesZones = timeZones.getMinutes().toString().padStart(2, '0');
  return `${hoursZones}:${minutesZones} ${ampmZones}`;
}

// function updateTime() {
//   const istTime = getLocalTime(5.5);
//   const estTime = getLocalTime(-5);
//   const cstTime = getLocalTime(-6);
//   const mstTime = getLocalTime(-7);
//   const pstTime = getLocalTime(-8);

//   document.getElementById('ist-time').textContent = formatTimeZones(istTime);
//   document.getElementById('est-time').textContent = formatTimeZones(estTime);
//   document.getElementById('cst-time').textContent = formatTimeZones(cstTime);
//   document.getElementById('mst-time').textContent = formatTimeZones(mstTime);
//   document.getElementById('pst-time').textContent = formatTimeZones(pstTime);
// }

function updateTime() {
  const now = new Date();

  function formatTimeZone(timeZone) {
    const formatter = new Intl.DateTimeFormat('en-US', {
      hour: 'numeric',
      minute: 'numeric',
      hour12: true,
      timeZone: timeZone,
    });
    return formatter.format(now);
  }

  document.getElementById('ist-time').textContent = formatTimeZone('Asia/Kolkata');
  document.getElementById('est-time').textContent = formatTimeZone('America/New_York');
  document.getElementById('cst-time').textContent = formatTimeZone('America/Chicago');
  document.getElementById('mst-time').textContent = formatTimeZone('America/Denver');
  document.getElementById('pst-time').textContent = formatTimeZone('America/Los_Angeles');
}

setInterval(updateTime, 1000);
updateTime();

// Update time every second
setInterval(updateTime, 1000);

// Initial update
updateTime();



/*==========================
Text Converter with Entities
==========================*/
document.addEventListener('DOMContentLoaded', function() {
  const inputText = document.getElementById('inputText');
  const convertedResult = document.getElementById('convertedResult');
  const entityBtn = document.getElementById('entityBtn');
  const uppercaseBtn = document.getElementById('uppercaseBtn');
  const lowercaseBtn = document.getElementById('lowercaseBtn');
  const propercaseBtn = document.getElementById('propercaseBtn');
  const sentencecaseBtn = document.getElementById('sentencecaseBtn');
  const titlecaseBtn = document.getElementById('titlecaseBtn');
  const superscriptBtn = document.getElementById('superscriptBtn');
  const widowBtn = document.getElementById('widowBtn');
  const widowSpanBtn = document.getElementById('widowSpanBtn');
  const copyBtn = document.getElementById('copyBtn');

  clearBtn.addEventListener('click', () => {
    inputText.value = '';
    convertedResult.value = '';
  });

  // Trim input on blur (when input loses focus)
  inputText.addEventListener('blur', () => {
    inputText.value = inputText.value.trim();
  });

  entityBtn.addEventListener('click', () => {
    let convertEntity = convertedResult.value || inputText.value; // Use convertedResult.value if it has content, otherwise/or inputText.value

    // Assign result to the "convertEntity" variable/string object
    // convertEntity.replace() uses string method to search for special character
    // Argument 1: (/entity/g, ) enclose special character in "/ /g" global regular expression pattern to replace all occurences of the special character
    // Argument 2: ( ,'replacement string') has entity for special char as string literal
    convertEntity = convertEntity.replace(/</g, '&lt;'); // Less than
    convertEntity = convertEntity.replace(/>/g, '&gt;'); // Greater than
    convertEntity = convertEntity.replace(/"/g, '&quot;'); // Quotation mark
    convertEntity = convertEntity.replace(/'/g, '&rsquo;'); // Apostrophe *RSQUO
    convertEntity = convertEntity.replace(/%/g, '&#37;'); // Percentage
    convertEntity = convertEntity.replace(/‑/g, '&#8209;'); // Non-breaking hyphen
    convertEntity = convertEntity.replace(/–/g, '&ndash;'); // En dash
    convertEntity = convertEntity.replace(/—/g, '&mdash;'); // Em dash
    convertEntity = convertEntity.replace(/-/g, '&#8209;'); // Hyphen or dash is Non-breaking hyphen
    convertEntity = convertEntity.replace(/“/g, '&ldquo;'); // Left double quote
    convertEntity = convertEntity.replace(/”/g, '&rdquo;'); // Right double quote
    convertEntity = convertEntity.replace(/‘/g, '&lsquo;'); // Left single quote
    convertEntity = convertEntity.replace(/’/g, '&rsquo;'); // Right single quote
    convertEntity = convertEntity.replace(/©/g, '&copy;'); // Copyright symbol
    convertEntity = convertEntity.replace(/®/g, '&reg;'); // Registered trademark symbol
    convertEntity = convertEntity.replace(/™/g, '&trade;'); // Trademark symbol
    convertEntity = convertEntity.replace(/€/g, '&euro;'); // Euro currency symbol
    convertEntity = convertEntity.replace(/¥/g, '&yen;'); // Yen currency symbol
    convertEntity = convertEntity.replace(/£/g, '&pound;'); // Pound sterling symbol
    convertEntity = convertEntity.replace(/¢/g, '&cent;'); // Cent symbol
    convertEntity = convertEntity.replace(/…/g, '&hellip;'); // Ellipsis
    convertEntity = convertEntity.replace(/•/g, '&bull;'); // Bullet point
    convertEntity = convertEntity.replace(/×/g, '&times;'); // Multiplication sign
    convertEntity = convertEntity.replace(/÷/g, '&divide;'); // Division sign
    convertEntity = convertEntity.replace(/±/g, '&plusmn;'); // Plus-minus sign
    convertEntity = convertEntity.replace(/\+/g, '&#43;'); // Plus sign
    convertEntity = convertEntity.replace(/°/g, '&deg;'); // Degree symbol
    convertEntity = convertEntity.replace(/‰/g, '&permil;'); // Per mille sign
    convertEntity = convertEntity.replace(/℠/g, '&#8480;'); // Service mark
    convertEntity = convertEntity.replace(/†/g, '&dagger;'); // Dagger symbol
    convertEntity = convertEntity.replace(/‡/g, '&Dagger;'); // Double dagger symbol
    convertEntity = convertEntity.replace(/§/g, '&sect;'); // Section sign
    convertEntity = convertEntity.replace(/»/g, '&raquo;'); // Right pointing double angle quotation mark
    convertEntity = convertEntity.replace(/«/g, '&laquo;'); // Left pointing double angle quotation mark
    convertEntity = convertEntity.replace(/―/g, '&#8213;'); // Horizontal bar
    convertEntity = convertEntity.replace(/~/g, '&tilde;'); // Tilde
    convertEntity = convertEntity.replace(/!/g, '&#33;'); // Exclamation point/mark
    convertEntity = convertEntity.replace(/@/g, '&#64;'); // At symbol
    convertEntity = convertEntity.replace(/\$/g, '&#36;'); // Dollar sign
    convertEntity = convertEntity.replace(/\^/g, '&#94;'); // Circumflex accent
    convertEntity = convertEntity.replace(/\*/g, '&#42;'); // Asterisk
    convertEntity = convertEntity.replace(/\(/g, '&#40;'); // Left parenthesis
    convertEntity = convertEntity.replace(/\)/g, '&#41;'); // Right parenthesis
    convertEntity = convertEntity.replace(/\{/g, '&#123;'); // Left curly bracket
    convertEntity = convertEntity.replace(/\}/g, '&#125;'); // Right curly bracket
    convertEntity = convertEntity.replace(/\[/g, '&#91;'); // Left square bracket
    convertEntity = convertEntity.replace(/\]/g, '&#93;'); // Right square bracket
    convertEntity = convertEntity.replace(/\|/g, '&#124;'); // Vertical line
    convertEntity = convertEntity.replace(/\//g, '&#47;'); // Forward Slash
    convertEntity = convertEntity.replace(/\\/g, '&#92;'); // Back Slash
    convertEntity = convertEntity.replace(/\?/g, '&#63;'); // Question mark
    convertEntity = convertEntity.replace(/¹/g, '&sup1;'); // Superscript one
    convertEntity = convertEntity.replace(/²/g, '&sup2;'); // Superscript two
    convertEntity = convertEntity.replace(/³/g, '&sup3;'); // Superscript three
    convertEntity = convertEntity.replace(/µ/g, '&micro;'); // Micro sign
    convertEntity = convertEntity.replace(/¶/g, '&para;'); // Paragraph sign
    convertEntity = convertEntity.replace(/_/g, '&#95;'); // Underscore
    convertEntity = convertEntity.replace(/:/g, '&#58;'); // Colon

    convertEntity = convertEntity.replace(/á/g, '&aacute;'); // Latin small letter a with acute
    convertEntity = convertEntity.replace(/é/g, '&eacute;'); // Latin small letter E with acute
    convertEntity = convertEntity.replace(/í/g, '&iacute;'); // Latin small letter I with acute

    convertEntity = convertEntity.replace(/ë/g, '&euml;'); // Latin small letter e diaeresis
    convertEntity = convertEntity.replace(/ï/g, '&iuml;'); // Latin small letter i diaeresis

    convertEntity = convertEntity.replace(/î/g, '&icirc;'); // Latin small letter I circumflex
    convertEntity = convertEntity.replace(/ó/g, '&oacute;'); // Latin small letter O with acute
    convertEntity = convertEntity.replace(/ú/g, '&uacute;'); // Latin small letter U with acute
    convertEntity = convertEntity.replace(/ñ/g, '&ntilde;'); // Latin small letter N with tilde
    convertEntity = convertEntity.replace(/Á/g, '&Aacute;'); // Latin capital letter A with acute
    convertEntity = convertEntity.replace(/É/g, '&Eacute;'); // Latin capital letter E with acute
    convertEntity = convertEntity.replace(/Í/g, '&Iacute;'); // Latin capital letter I with acute
    convertEntity = convertEntity.replace(/Ó/g, '&Oacute;'); // Latin capital letter O with acute
    convertEntity = convertEntity.replace(/Ú/g, '&Uacute;'); // Latin capital letter U with acute
    convertEntity = convertEntity.replace(/Ñ/g, '&Ntilde;'); // Latin capital letter N with tilde
    convertEntity = convertEntity.replace(/¿/g, '&iquest;'); // Inverted question mark
    convertEntity = convertEntity.replace(/¡/g, '&iexcl;'); // Inverted exclamation mark
    convertEntity = convertEntity.replace(/ä/g, '&auml;'); // Latin Small Letter A with Diaeresis (Umlaut)
    convertEntity = convertEntity.replace(/ö/g, '&ouml;'); // Latin Small Letter O with Diaeresis (Umlaut)
    convertEntity = convertEntity.replace(/ü/g, '&uuml;'); // Latin Small Letter U with Diaeresis (Umlaut)
    convertEntity = convertEntity.replace(/ß/g, '&szlig;'); // Latin Small Letter Sharp S (Eszett)
    convertEntity = convertEntity.replace(/Ä/g, '&Auml;'); // Latin Capital Letter A with Diaeresis (Umlaut)
    convertEntity = convertEntity.replace(/Ö/g, '&Ouml;'); // Latin Capital Letter O with Diaeresis (Umlaut)
    convertEntity = convertEntity.replace(/Ü/g, '&Uuml;'); // Latin Capital Letter U with Diaeresis (Umlaut)
    convertEntity = convertEntity.replace(/ç/g, '&ccedil;'); // Latin small letter c cedilla
    convertEntity = convertEntity.replace(/Ç/g, '&Ccedil;'); // Latin capital letter c cedilla
    convertEntity = convertEntity.replace(/`/g, '&#96;'); // Grave Accent
    convertEntity = convertEntity.replace(/´/g, '&acute;'); // Acute Accent

    //convertEntity = convertEntity.replace(/#/g, '&#35;'); // Number sign
    //convertEntity = convertEntity.replace(/;/g, '&semi;'); // Not Converting Semicolon
    //convertEntity = convertEntity.replace(/&/g, '&amp;'); // Ampersand
    //convertEntity = convertEntity.replace(/&num;/g, '#'); // Revert Num Conversion
    convertedResult.value = convertEntity.replace(/&semi/g, ''); // Remove &semi; from the final output
  });

  uppercaseBtn.addEventListener('click', () => {
    let text = convertedResult.value || inputText.value; // Use convertedResult.value if it has content, otherwise inputText.value
    convertedResult.value = inputText.value.toUpperCase();
  });

  lowercaseBtn.addEventListener('click', () => {
    let text = convertedResult.value || inputText.value; // Use convertedResult.value if it has content, otherwise inputText.value
    convertedResult.value = inputText.value.toLowerCase();
  });

  propercaseBtn.addEventListener('click', () => {
    let text = convertedResult.value || inputText.value; // Use convertedResult.value if it has content, otherwise inputText.value
    const words = inputText.value.toLowerCase().split(' ');
    const properCase = words.map(word => word.charAt(0).toUpperCase() + word.slice(1)).join(' ');
    convertedResult.value = properCase;
  });

  sentencecaseBtn.addEventListener('click', () => {
    const text = (convertedResult.value || inputText.value).trim(); // Use convertedResult.value if it has content, otherwise inputText.value
    if (text) {
        const sentences = text.split(/([.!?] )/); // Split by . ! ? followed by a space

        const sentenceCase = sentences.map((sentence, index) => {
            if (index % 2 === 0) { // Only process the actual sentence parts
                const trimmedSentence = sentence.trim();
                if (trimmedSentence) {
                    const firstChar = trimmedSentence.charAt(0).toUpperCase();
                    const restOfSentence = trimmedSentence.slice(1).toLowerCase();
                    return firstChar + restOfSentence;
                }
                return "";
            } else {
                return sentence; // Keep the delimiter (. ! ? and space) as is
            }
        }).join('');

        convertedResult.value = sentenceCase;
    } else {
        convertedResult.value = "";
    }
  });

  titlecaseBtn.addEventListener('click', () => {
    let text = convertedResult.value || inputText.value;
    const titleExceptions = ['a', 'an', 'the', 'at', 'by', 'in', 'of', 'on', 'to', 'up', 'and', 'but', 'or', 'nor', 'so', 'yet'];
    const words = text.toLowerCase().split(' ');
  
    const titleCase = words.map((word, index) => {

      const cleanedWord = word.trim().replace(/[^\w\s]/g, '');
  
      if (index === 0 || !titleExceptions.includes(cleanedWord)) {
        return word.charAt(0).toUpperCase() + word.slice(1);
      } else {
        return word;
      }
    }).join(' ');
  
    convertedResult.value = titleCase;
  });

  // Widows with &nbsp;
  widowBtn.addEventListener('click', () => {
    let text = convertedResult.value || inputText.value;
    const widowParagraphs = text.split('\n');
  
    const modifiedParagraphs = widowParagraphs.map(widowParagraph => {
      const lastSpaceIndex = widowParagraph.lastIndexOf(' ');
      if (lastSpaceIndex !== -1) {
        return widowParagraph.substring(0, lastSpaceIndex) + '&nbsp;' + widowParagraph.substring(lastSpaceIndex + 1);
      }
      return widowParagraph;
    });
  
    convertedResult.value = modifiedParagraphs.join('\n');
  });

  widowSpanBtn.addEventListener('click', () => {
    let text = convertedResult.value || inputText.value;
    const spanWidowParagraphs = text.split('\n');
  
    const modifiedParagraphs = spanWidowParagraphs.map(spanWidowParagraph => {
      const lastSpaceIndex = spanWidowParagraph.lastIndexOf(' ');
      if (lastSpaceIndex !== -1) {
        return spanWidowParagraph.substring(0, lastSpaceIndex) + '<span>&nbsp;</span>' + spanWidowParagraph.substring(lastSpaceIndex + 1);
      }
      return spanWidowParagraph;
    });
  
    convertedResult.value = modifiedParagraphs.join('\n'); // Join back with double newlines for consistency
  });


  superscriptBtn.addEventListener('click', () => {
    let text = convertedResult.value; // Use only convertedResult.value
    if (text) { // Only proceed if there's content in convertedResult
      text = text.replace(/&#8480;/g, '<sup>&#8480;</sup>'); // Service mark
      text = text.replace(/&reg;/g, '<sup>&reg;</sup>'); // Registered trademark
      text = text.replace(/&trade;/g, '<sup>&trade;</sup>'); // Trademark
      text = text.replace(/&dagger;/g, '<sup>&dagger;</sup>'); // Dagger
      text = text.replace(/&Dagger;/g, '<sup>&Dagger;</sup>'); // Dagger
      text = text.replace(/&sect;/g, '<sup>&sect;</sup>'); // Section sign
      convertedResult.value = text;
    }
  });

  copyBtn.addEventListener('click', () => {
    if (convertedResult.value.trim()) { // Check if convertedResult.textContent is not empty after trimming whitespace
      navigator.clipboard.writeText(convertedResult.value).then(() => {
        console.log('convertedResult copied to clipboard!');
        convertedResult.classList.add("copied")
        copyBtn.classList.add("copied")
      }).catch(err => {
        console.error('Could not copy text: ', err);
      });
      setTimeout(() => {
        convertedResult.classList.remove('copied'); 
        copyBtn.classList.remove('copied'); 
      }, 1500); 
    } else {
      console.log('Nothing to copy.'); // Log message that there was nothing to copy.
    }
  }); //End copyBtn Function
}); //End Dom Content Loaded



/*==========================
PT to PX Converter in Code Snippets Section
==========================*/
const pxInput = document.getElementById('pxInput');
const ptInput = document.getElementById('ptInput');
const copyPxButton = document.getElementById('copyPx');
const copyPtButton = document.getElementById('copyPt');

function pxToPt(pxValue) {
  return pxValue * 0.75;
}

function ptToPx(ptValue) {
  return ptValue / 0.75;
}

function formatNumber(value) {
  return parseFloat(value).toFixed(2).replace(/\.?0+$/, ""); 
}

pxInput.addEventListener('input', () => {
  const pxValue = parseFloat(pxInput.value);
  if (!isNaN(pxValue)) {
    ptInput.value = formatNumber(pxToPt(pxValue)); 
  } else {
    ptInput.value = ''; 
  }
});

ptInput.addEventListener('input', () => {
  const ptValue = parseFloat(ptInput.value);
  if (!isNaN(ptValue)) {
    pxInput.value = formatNumber(ptToPx(ptValue)); 
  } else {
    ptInput.value = ''; 
  }
});

function copyToClipboard(inputId, buttonId) {
  const inputPxPt = document.getElementById(inputId);
  const buttonPxPt = document.getElementById(buttonId);

  if (inputPxPt.value.trim() !== '') { 
    navigator.clipboard.writeText(inputPxPt.value)
      .then(() => {
        inputPxPt.classList.add('copied');
        buttonPxPt.classList.add('copied');
      })
      .catch(err => {
        console.error('Failed to copy: ', err);
      }); 

    setTimeout(() => {
      inputPxPt.classList.remove('copied'); 
      buttonPxPt.classList.remove('copied'); 
    }, 1000); 
  }
}


/*==========================
Clear Local Storage & Refresh Page
==========================*/
const clearCacheButton = document.getElementById('clearCacheButton');
clearCacheButton.addEventListener('click', () => {
  localStorage.clear();
  location.reload();
});


/*==========================
Checklists Section for Reviews/Builds/Changes
==========================*/
const checkboxes = document.querySelectorAll('.custom-checkbox');
const resetButtons = document.querySelectorAll('.reset-button');

checkboxes.forEach(checkbox => {
    checkbox.addEventListener('click', () => {
        checkbox.classList.toggle('checked');
    });
});

resetButtons.forEach(button => {
    button.addEventListener('click', () => {
        const listNumber = button.dataset.list;
        const list = document.getElementById(`check-list-${listNumber}`);
        const checkboxesInList = list.querySelectorAll('.custom-checkbox');
        checkboxesInList.forEach(checkbox => {
            checkbox.classList.remove('checked');
        });
    });
});



/*==========================
Documentation Toggle Render Search Tool
==========================*
document.addEventListener('DOMContentLoaded', function() {
  const renderSearchToggle = document.getElementById('renderSearchToggle');
  const renderSearchSection = document.getElementById('render-search');
  const renderSearchNav = document.getElementById('render-search-nav');

  // Load the cached state from localStorage
  const cachedState = localStorage.getItem('renderSearchSectionState');
  if (cachedState === 'none') {
    renderSearchSection.style.display = 'flex';
    renderSearchNav.style.display = 'flex';
    renderSearchToggle.checked = true;
  } else {
    renderSearchSection.style.display = 'none';
    renderSearchNav.style.display = 'none';
    renderSearchToggle.checked = false;
  }

  renderSearchToggle.addEventListener('change', function() {
    if (this.checked) {
      renderSearchSection.style.display = 'flex';
      renderSearchNav.style.display = 'flex';
      localStorage.setItem('renderSearchSectionState', 'none');
    } else {
      renderSearchSection.style.display = 'none';
      renderSearchNav.style.display = 'none';
      localStorage.setItem('renderSearchSectionState', 'flex');
    }
  });
});



/*==========================
Documentation Toggle Code Snippet Prep Tool
==========================*
document.addEventListener('DOMContentLoaded', function() {
  const snippetToolToggle = document.getElementById('snippetToolToggle');
  const codeSnippetTool = document.getElementById('codeSnippetTool');

  // Load the cached state from localStorage
  const cachedState = localStorage.getItem('codeSnippetToolState');
  if (cachedState === 'none') {
    codeSnippetTool.style.display = 'flex';
    snippetToolToggle.checked = true;
  } else {
    codeSnippetTool.style.display = 'none';
    snippetToolToggle.checked = false;
  }

  snippetToolToggle.addEventListener('change', function() {
    if (this.checked) {
      codeSnippetTool.style.display = 'flex';
      localStorage.setItem('codeSnippetToolState', 'flex');
    } else {
      codeSnippetTool.style.display = 'none';
      localStorage.setItem('codeSnippetToolState', 'none');
    }
  });
});

/*-- Scroll To Code Snippet Tool from Documentation Offset --*/
function scrollWithOffset(codeSnippetTool, offset) {
  const codeSnippetToolScroll = document.getElementById(codeSnippetTool);
  const codeSnippetToolPosition = codeSnippetToolScroll.getBoundingClientRect().top;
  const codeSnippetToolOffset = codeSnippetToolPosition + window.pageYOffset - offset;

  window.scrollTo({
    top: codeSnippetToolOffset,
    behavior: 'smooth' // Optional: smooth scrolling
  });
}



/*==========================
 Ralph Rolled
==========================*/
const seenRalph = document.querySelector('.ralph-link');

/*-- Music Player and Link --*/
let ralphAudioIsPlaying = false;
let ralphLinkOpened = false;

  document.getElementById("playRickRoll").addEventListener("click", function() {
  const ralphAudio = document.getElementById("rickRollAudio");
  if (!ralphAudioIsPlaying) {
    ralphAudio.play();
    ralphAudioIsPlaying = true;
    seenRalph.classList.add('replace-ralph-link');
    seenRalph.classList.remove('ralph-link');

    // Open the link only on the first click
    if (!ralphLinkOpened) {
      window.open("https://jokesoftheday.net", "_blank");
      ralphLinkOpened = true;
    }
  } else {
    ralphAudio.pause();
    ralphAudioIsPlaying = false;
    seenRalph.classList.remove('replace-ralph-link');
    seenRalph.classList.add('ralph-link');
  }
  });



/*==========================
Magnific Popup Dev Event Calendar
==========================*/
$('.open-popup-link').magnificPopup({
  type:'inline',
  midClick: true // Allow opening popup on middle mouse click. Always set it to true if you don't provide alternative source in href.
});

