function updateWeatherWidget(url) {
	// Ensure the URL includes "?unit=us"
	if (!url.endsWith("?unit=us")) {
	  url += "?unit=us";
	}
 
	// Store the modified URL in local storage
	localStorage.setItem("weatherWidgetUrl", url);
 
	// Replace all existing weather widget links with the new URL
	const existingWidgets = document.querySelectorAll(".weatherwidget-io");
	for (const widget of existingWidgets) {
	  widget.href = url;
	}
 }
 
 function getStoredUrl() {
	// Retrieve the stored URL from local storage (if available)
	const storedUrl = localStorage.getItem("weatherWidgetUrl");
	return storedUrl;
 }
 
 // Load the stored URL on page load and update the widget
 const storedUrl = getStoredUrl();
 if (storedUrl) {
	document.getElementById("weather-url").value = storedUrl;
	updateWeatherWidget(storedUrl); // Call updateWeatherWidget to replace the link
 }
 
 !function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0];if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src='https://weatherwidget.io/js/widget.min.js';fjs.parentNode.insertBefore(js,fjs);}}(document,'script','weatherwidget-io-js');